#pragma once

#if EG_WIN

// ### in your global header, define USE_DIRECTX 1 if you want full screeen ability!!!
#if USE_DIRECTX
#include <ddraw.h>
#else
typedef long LPDIRECTDRAW;
typedef long LPDIRECTDRAWSURFACE;
#endif

#endif



#if EG_MAC

// ### in your global header, define USE_DRAW_SPROCKETS 1 if you want full screeen ability!!!
#include <QuickDraw.h>
#include <QDOffscreen.h>

#if USE_DRAW_SPROCKETS
#include <DrawSprocket.h>
#else
typedef long DSpContextReference;
struct DSpContextAttributes	{ };
#endif
#else
#endif

#include "UtilStr.h"




#define __Clr8(r,g,b)	0
#define __Clr16(r,g,b)	((( ((unsigned long) r) & 0xF800) >> 1) | ((((unsigned long) g) & 0xF800) >> 6) | (((unsigned long) b) >> 11))
#if EG_MAC 
#define	__Clr32(r,g,b)	(((r & 0xFF00) << 8) | (g & 0xFF00) | (b >> 8))
#elif EG_WIN
#define	__Clr32(r,g,b)	__winRGB( r, g, b )
#endif

#define __ClrREF( rgb ) __Clr32( rgb.red, rgb.green, rgb.blue )



/*  PixPort is a platform indep drawing world/environment.  You set the size of one using
Init() and then execute whatever drawing commands. When the drawing is complete, CopyBits() 
copies pixel data from this world to the given destination OS graphics world.  */
	



/* 
	This class wraps around Apple's GameSprokets suite, DrawSprokets.  It implements page 
flipping whenever possible, allowing for very high performance grafx.  To use it, make 
an instance of CDrawSproket at the start of your prog, call TryInit(), then Activate()
and you're all set via SwapBuffers().  When you're done using the display, you must call
Deactivate() to give the display back to the OS for normal use.
*/

class PixPort {


	public:
	
		friend class PixPort;
								 PixPort();
		virtual					~PixPort();

		// These *must* be called once at the start and end of the program respectively.
		// Otherwise DrawSprokets never get initialized--and that's very bad.
		//	If Startup() returns false, it means fullscreen is not available!!
		static void				Startup();
		static void				Shutdown();

		// Util fcn that returns the display number of the given mouse point in global cords.
		// If 0 is returned if the call failed.  Use the number returned here for InitFullscreen()
		static long				GetOwningDisplay( const Point& inPt );
		
		// Returns true if PixPorts are able to take over a screen
		static bool				FullscreenAvail()							{ return sCanFullscreen;	}

		// One or the other must be called before a PixPort is used.  If inDepth is 0 or invalid,
		// the current OS depth is used.  Call Deactivate() or Init() to exit fullscreen mode.
		// inWin is passed because PixPort may need the window that's going fullscreen
		void					Init( int inWidth, int inHeight, int inDepth = 0 );
		bool					InitFullscreen( int inDispNum, Point& outSize, WindowPtr inWin, int inBitDepth = 0  );
	
		// Returns true if currently in fullscreen mode (ie, InitFullscreen() returned true)
		inline bool				IsFullscreen() const						{ return mContextRef != 0; }
			
		//	Politely returns the activated display to it's normal state before Activate();
		void					Deactivate();

		// Returns the current bit color depth from Init(). (8, 16, or 32)
		long					GetDepth()											{ return mBytesPerPix * 8; 	}
	
		//	Sets the background colors (for erase rect and Blur() )
		//  Returns the new pixel entry for the given color and this port
		long					SetBackColor( const RGBColor& inColor );
		long					SetBackColor( long inR, long inG, long inB );

		//	Be sure this is called before and after *any* of the following calls
		void					BeginFrame();
		void					EndFrame();

		//	Blurs the rect given in this image, with a given box filter of size (1=no blur)
		//	If the dest is NULL, the blur is applied to itself
		void					GaussBlur( int inBoxWidth, const Rect& inRect, void* inDestBits = NULL );	
		
		//	A different, more primitive blur that doesn't look as good as GaussBlur,
		void					CrossBlur( const Rect& inRect );

		// 	Sets the width of the pen
		void					SetLineWidth( long inWidth );
		
		//	Draw a line.  Use GetPortColor() to get a device color for a RGB
		void					Line( int sx, int sy, int ex, int ey, long inColor );
		void					Line( int sx, int sy, int ex, int ey, const RGBColor& inS, const RGBColor& inE );

		inline long				GetPortColor_inline( long inR, long inG, long inB ) {
			if ( mBytesPerPix == 2 )
				return __Clr16( inR, inG, inB );
			else if ( mBytesPerPix == 4 ) 
				return __Clr32( inR, inG, inB );
			else
				return __Clr8( inR, inG, inB );
		}
		
		//	Set the given rect to the current background color.  If no rect is specified, the entire port rect is cleared.
		void					EraseRect( const Rect* inRect = NULL );
		
		//	Copies the pixels in a rectangle from this image to the destination
		void					CopyBits( WindowPtr inDest, const Rect* inSrcRect, const Rect* inDestRect );

				
		//	Gets a port/device color for a given RGB		
		long					GetPortColor( long inR, long inG, long inB );
		inline long				GetPortColor( const RGBColor& inColor )  		{ return GetPortColor( inColor.red, inColor.green, inColor.blue );  }
	
		//	The guts for G-Force...  This PixPort must be in 8-bit mode to do anything.
		void					Fade( PixPort& ioDest, char* inGrad );
		
		// When in fullscreen, use this (on mac) to declare what's area needs to be updated on screen
		void					UnionDirtyRect( const Rect* inDirtyRect );
				
		//	When this sprocket is set to 256 colors, you may change the palette it's using any time
		//	Pre: inColors[].rgb is the RGB of palette entry i.
		//	Post:  The current palette is set to inColors[]
		//void					SetPalette( ColorSpec inColors[ 256 ] );

		long					GetX()			{ return mX; }
		long					GetY()			{ return mY; }
				
		static long				sMinDepth;
		static long				sOSDepth;

		
		#define MAX_LINE_WIDTH		32
	
		
	protected:

		static long				sCanFullscreen;
	
		long					mBytesPerPix;
		long					mBytesPerRow;
		long					mX, mY;
		long					mBackColor;
		long					mLineWidth;
		UtilStr					mTempBuf;
		
		char*					mBits;
		
		PixMapHandle			mBM;
		GWorldPtr				mWorld;
		
		#if EG_WIN
		BITMAPINFO				mInfo;
		LPDIRECTDRAWSURFACE		mContextRef;
		LPDIRECTDRAW			mDDObj;
		#endif
		
		#if EG_MAC
		char**					mTempHndl;
		long					mHndlSize;
		DSpContextReference		mContextRef;
		DSpContextAttributes	mContext;
		#endif
		
		
		void					EraseRect8 ( const Rect* inRect );
		void					EraseRect16( const Rect* inRect );
		void					EraseRect32( const Rect* inRect );


		static void				BoxBlur8 ( char* inSrce, char* inDest, int inBoxWidth, int inWidth, int inHeight, int inSrceRowSize, int inDestRowSize, unsigned long* temp, unsigned long inBackColor ); 
		static void				BoxBlur16( char* inSrce, char* inDest, int inBoxWidth, int inWidth, int inHeight, int inSrceRowSize, int inDestRowSize, unsigned long* temp, unsigned long inBackColor ); 
		static void				BoxBlur32( char* inSrce, char* inDest, int inBoxWidth, int inWidth, int inHeight, int inSrceRowSize, int inDestRowSize, unsigned long* temp, unsigned long inBackColor ); 

		static void				CrossBlur8 ( char* inSrce, int inWidth, int inHeight, int inBytesPerRow, unsigned char* inRowBuf );
		static void				CrossBlur16( char* inSrce, int inWidth, int inHeight, int inBytesPerRow, unsigned char* inRowBuf );
		static void				CrossBlur32( char* inSrce, int inWidth, int inHeight, int inBytesPerRow, unsigned char* inRowBuf );

		void					Line8 ( int sx, int sy, int ex, int ey, long inColor );
		void					Line16( int sx, int sy, int ex, int ey, long inColor );
		void					Line32( int sx, int sy, int ex, int ey, long inColor );


		void					Line8 ( int sx, int sy, int ex, int ey, const RGBColor& inS, long dR, long dG, long dB );
		void					Line16( int sx, int sy, int ex, int ey, const RGBColor& inS, long dR, long dG, long dB );
		void					Line32( int sx, int sy, int ex, int ey, const RGBColor& inS, long dR, long dG, long dB );


		//static void				movePt( int& ioX, int& ioY, int inDx, int inDy, int inDist );

};